% -------------------------------------------------------------------
% Este script resuelve la ecuacin para la desintegracin de una
% especie radiactiva usando el mtodo de Adams-Basforth de 3er orden
% Requiere que en el espacio de trabajo exista la
% funcin fAdamsBas3 y tambin fRK4 (ver la documentacin de la funcin
% fAdamsBas3).
% dy/dx = f(x,y;k) = - k*y:
% -------------------------------------------------------------------

%Definiciones y parmetros

k=1;
g = @(t,y) -k*y;
y0=100;
t0=0;
tf=5;
Nh=10;

%Solucin numrica por el mtodo de Adams-Basforth (3er orden)

[t,y]=fAdamsBas3(g,t0,tf,y0,Nh);

%Solucin exacta

tp=0:0.1:5;
yp=y0*exp(-k*tp);

%Representacin grfica

plot(tp,yp,t,y,'o','MarkerEdgeColor','r');
xlabel('t');
ylabel('N');
title('Mtodo de Adams-Basforth');
legend('Sol. exacta','Sol. numrica');
text(2,70,'k=1, Nh=10');
